<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AddUserController extends Controller
{
    // Show form + user list
    public function create()
    {
        $users = DB::table('users')->get();
        return view('admin.adduser', compact('users'));
    }

    // Store new user
    public function store(Request $request)
    {
        $request->validate([
            'username' => 'required|string|max:255|unique:users,username',
            'password' => 'required|string|min:5',

            'shop_name' => 'required|string|max:255',
            'owner_name' => 'required|string|max:255',
            'role_id' => 'required|integer',
            'phone' => 'nullable|numeric|digits_between:7,10', // only numbers allowed, 7-10 digits
            'status' => 'required|integer',
        ]);

        DB::table('users')->insert([
            'username' => $request->username,
            'password' => $request->password,
            'shop_name' => $request->shop_name,
            'owner_name' => $request->owner_name,
            'role_id' => $request->role_id,
            'phone' => $request->phone,
            'status' => $request->status,
            'created_at' => now(),
            'updated_at' => now()
        ]);

        return redirect()->route('admin.create')->with('success', 'User created successfully.');
    }

    // Show edit form
    public function edit($id)
    {
        $editUser = DB::table('users')->where('id', $id)->first();
        $users = DB::table('users')->get(); // always fetch all users for table
        return view('admin.adduser', compact('users', 'editUser'));
    }


    // Update user
    public function update(Request $request, $id)
    {
        $request->validate([
            'username' => 'required|string|max:255|unique:users,username,'.$id,
            'shop_name' => 'required|string|max:255',
            'owner_name' => 'required|string|max:255',
            'role_id' => 'required|integer',
            'phone' => 'nullable|string|max:15',
            'status' => 'required|integer',
        ]);

        DB::table('users')->where('id', $id)->update([
            'username' => $request->username,
            'shop_name' => $request->shop_name,
            'owner_name' => $request->owner_name,
            'role_id' => $request->role_id,
            'phone' => $request->phone,
            'status' => $request->status,
            'updated_at' => now()
        ]);

        return redirect()->route('admin.create')->with('success', 'User updated successfully.');
    }

    // Delete user
    public function destroy($id)
    {
        DB::table('users')->where('id', $id)->delete();
        return redirect()->route('admin.create')->with('success', 'User deleted successfully.');
    }
}
