<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Models\Auth\User;
use App\Models\User\Shop_Profiles;

class AccountController extends Controller
{
    // ----------------------------
    // Show Profile Page
    // ----------------------------
    public function profile()
    {
        $userId = session('user_id');

    // Fetch or return empty model if not created yet
    $profile = Shop_Profiles::where('user_id', $userId)->first();



    return view('account.profile', compact('profile'));
    }

    // ----------------------------
    // Update Profile
    // ----------------------------
    public function updateProfile(Request $request)
    {
        $request->validate([
            'username'   => 'required|string|max:255',
            'shopname'   => 'nullable|string|max:255',
            'owner_name' => 'nullable|string|max:255',
        ]);

        $user = User::find(session('user_id'));

        if (!$user) return redirect()->back()->with('error', 'User not found');

        $user->username   = $request->username;
        $user->shop_name  = $request->shopname;
        $user->owner_name = $request->owner_name;
        $user->save();

        // Update session
        $request->session()->put([
            'username'   => $user->username,
            'shopname'   => $user->shop_name,
            'owner_name' => $user->owner_name,
        ]);

        return redirect()->back()->with('success', 'Profile updated successfully');
    }

    // ----------------------------
    // Show Settings Page
    // ----------------------------
    public function settings()
    {
        $settings = [
            'theme' => session('theme') ?? 'light'
        ];
        return view('account.settings', compact('settings'));
    }

    // ----------------------------
    // Update Password
    // ----------------------------
    public function updatePassword(Request $request)
    {
        $request->validate([
            'current_password' => 'required|string',
            'new_password'     => 'required|string|min:6|confirmed',
        ]);

        $user = User::find(session('user_id'));
        if (!$user) return redirect()->back()->with('error', 'User not found');

        if (!Hash::check($request->current_password, $user->password)) {
            return redirect()->back()->with('error', 'Current password is incorrect');
        }

        $user->password = Hash::make($request->new_password);
        $user->save();

        return redirect()->back()->with('success', 'Password updated successfully');
    }

    // ----------------------------
    // Update Theme (optional AJAX)
    // ----------------------------
    public function updateTheme(Request $request)
    {
        $theme = $request->theme ?? 'light';
        session(['theme' => $theme]);

        $user = User::find(session('user_id'));
        if ($user) {
            $user->theme = $theme;
            $user->save();
        }

        return response()->json(['success' => true]);
    }

    // ----------------------------
    // Switch Language
    // ----------------------------
    public function switchLanguage($locale, Request $request)
    {
        $available = ['en', 'ta'];
        if (!in_array($locale, $available)) $locale = 'en';

        session(['locale' => $locale]);

        return redirect()->back();
    }
}
