<?php

namespace App\Helpers;

use Stichoza\GoogleTranslate\GoogleTranslate;

class Translator
{
    public static function t($text)
    {
        $locale = session('locale', 'en'); // default English

        if ($locale == 'en') return $text; // no translation needed

        try {
            $tr = new GoogleTranslate();
            $tr->setTarget($locale);
            return $tr->translate($text);
        } catch (\Exception $e) {
            return $text; // fallback if translation fails
        }
    }
}
