<?php

namespace App\Helpers;

use Stichoza\GoogleTranslate\GoogleTranslate;
use Illuminate\Support\Facades\Cache;

class FastTranslate
{
    public static function toTamil($text)
    {
        if (!$text) return null;

        // Cache key
        $key = 'ta_' . md5($text);

        // Cache for 1 year (instant next time)
        return Cache::rememberForever($key, function () use ($text) {
            $tr = new GoogleTranslate('ta');
            return $tr->translate($text);
        });
    }
}
